/*
 * Decompiled with CFR 0.152.
 */
package net.nebulabc.essentials.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DB {
    public static final Connection conn;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean getSocialSpyStatus(String uuid) {
        String sql = "SELECT socialspy_enabled FROM user_settings WHERE user_uuid = ?";
        try {
            PreparedStatement stmt = conn.prepareStatement(sql);
            stmt.setString(1, uuid);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    boolean bl2 = rs.getBoolean("socialspy_enabled");
                    return bl2;
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean toggleSocialSpy(String uuid) {
        String insert = "INSERT INTO user_settings (user_uuid, socialspy_enabled) VALUES (?, FALSE) ON CONFLICT (user_uuid) DO NOTHING";
        try {
            PreparedStatement stmt = conn.prepareStatement(insert);
            stmt.setObject(1, uuid);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        String update = "UPDATE user_settings SET socialspy_enabled = NOT socialspy_enabled WHERE user_uuid = ? RETURNING socialspy_enabled";
        try {
            PreparedStatement stmt = conn.prepareStatement(update);
            stmt.setObject(1, uuid);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) throw new IllegalStateException("Failed to toggle socialspy for user: " + uuid);
                boolean bl = rs.getBoolean("socialspy_enabled");
                return bl;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void enableSocialSpy(String uuid) {
        String insert = "INSERT INTO user_settings (user_uuid, socialspy_enabled) VALUES (?, TRUE) ON CONFLICT (user_uuid) DO NOTHING";
        try {
            PreparedStatement stmt = conn.prepareStatement(insert);
            stmt.setObject(1, uuid);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        String update = "UPDATE user_settings SET socialspy_enabled = TRUE WHERE user_uuid = ?";
        try {
            PreparedStatement stmt = conn.prepareStatement(update);
            stmt.setObject(1, uuid);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void disableSocialSpy(String uuid) {
        String insert = "INSERT INTO user_settings (user_uuid, socialspy_enabled) VALUES (?, TRUE) ON CONFLICT (user_uuid) DO NOTHING";
        try {
            PreparedStatement stmt = conn.prepareStatement(insert);
            stmt.setObject(1, uuid);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        String update = "UPDATE user_settings SET socialspy_enabled = FALSE WHERE user_uuid = ?";
        try {
            PreparedStatement stmt = conn.prepareStatement(update);
            stmt.setObject(1, uuid);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            conn = DriverManager.getConnection("jdbc:sqlite:essentials/primary.db");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

