/*
 * Decompiled with CFR 0.152.
 */
package net.nebulabc.essentials.mixin;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.ArgumentTypeString;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.builder.ArgumentBuilderRequired;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.command.arguments.ArgumentTypeEntity;
import net.minecraft.core.net.command.commands.CommandMessage;
import net.minecraft.core.net.command.helpers.EntitySelector;
import net.minecraft.server.MinecraftServer;
import net.nebulabc.essentials.config.category.Global;
import net.nebulabc.essentials.util.DB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={CommandMessage.class}, remap=false)
public abstract class MixinCommandMessage {
    @Overwrite
    public void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralCommandNode command = dispatcher.register((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"message").then(ArgumentBuilderRequired.argument((String)"targets", (ArgumentType)ArgumentTypeEntity.usernames()).then(ArgumentBuilderRequired.argument((String)"message", (ArgumentType)ArgumentTypeString.greedyString()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            MinecraftServer server = MinecraftServer.getInstance();
            EntitySelector entitySelector = (EntitySelector)c.getArgument("targets", EntitySelector.class);
            String message = (String)c.getArgument("message", String.class);
            if (source.getSender() == null) {
                return 0;
            }
            String senderName = source.getSender().getDisplayName();
            List players = entitySelector.get(source);
            for (Entity player : players) {
                source.sendMessage(TextFormatting.LIGHT_GRAY.toString() + TextFormatting.ITALIC.toString() + I18n.getInstance().translateKeyAndFormat("command.commands.message.outgoing", new Object[]{TextFormatting.removeAllFormatting((String)((Player)player).getDisplayName()), message}));
                source.sendMessage((Player)player, TextFormatting.LIGHT_GRAY + TextFormatting.ITALIC + I18n.getInstance().translateKeyAndFormat("command.commands.message.incoming", new Object[]{TextFormatting.removeAllFormatting((String)senderName), message}));
            }
            if (Global.socialspyMessages.booleanValue()) {
                for (Entity player : server.playerList.playerEntities) {
                    if (!player.isOperator() || !DB.getSocialSpyStatus(String.valueOf(player.uuid))) continue;
                    for (Entity dest : players) {
                        String sourceName = Global.socialspyUsesDisplaynames != false ? source.getSender().getDisplayName() : source.getSender().username;
                        String destName = Global.socialspyUsesDisplaynames != false ? ((Player)dest).getDisplayName() : ((Player)dest).username;
                        player.sendMessage(TextFormatting.ORANGE + "[" + TextFormatting.RESET + sourceName + TextFormatting.ORANGE + " -> " + TextFormatting.RESET + destName + TextFormatting.ORANGE + "] " + TextFormatting.RESET + message);
                    }
                }
            }
            return 1;
        }))));
        dispatcher.register((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"msg").redirect((CommandNode)command));
        dispatcher.register((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"whisper").redirect((CommandNode)command));
        dispatcher.register((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"tell").redirect((CommandNode)command));
    }
}

