/*
 * Decompiled with CFR 0.152.
 */
package net.nebulabc.essentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.ArgumentTypeString;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.builder.ArgumentBuilderRequired;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.command.arguments.ArgumentTypeEntity;
import net.minecraft.core.net.command.exceptions.CommandExceptions;
import net.minecraft.core.net.command.helpers.EntitySelector;
import net.minecraft.server.entity.player.PlayerServer;
import net.minecraft.server.net.command.IServerCommandSource;
import net.nebulabc.essentials.util.DB;

public class Socialspy
implements CommandManager.CommandRegistry {
    public void register(CommandDispatcher<CommandSource> commandDispatcher) {
        List<String> aliases = Arrays.asList("socialspy", "esocialspy");
        for (String alias : aliases) {
            commandDispatcher.register((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)alias).requires(CommandSource::hasAdmin)).executes(this::exec1)).then(((ArgumentBuilderRequired)ArgumentBuilderRequired.argument((String)"user", (ArgumentType)ArgumentTypeEntity.username()).executes(this::exec2)).then(ArgumentBuilderRequired.argument((String)"state", (ArgumentType)ArgumentTypeString.word()).executes(this::exec3))));
        }
    }

    private int exec1(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        if (!(ctx.getSource() instanceof IServerCommandSource)) {
            throw CommandExceptions.multiplayerWorldOnly().create();
        }
        Player sender = Objects.requireNonNull(((CommandSource)ctx.getSource()).getSender());
        String status = DB.toggleSocialSpy(sender.uuid.toString()) ? "enabled" : "disabled";
        sender.sendMessage(TextFormatting.ORANGE + "SocialSpy for " + TextFormatting.RESET + sender.getDisplayName() + TextFormatting.ORANGE + ": " + TextFormatting.RED + status);
        return 0;
    }

    private int exec2(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        if (!(ctx.getSource() instanceof IServerCommandSource)) {
            throw CommandExceptions.multiplayerWorldOnly().create();
        }
        Player sender = ((CommandSource)ctx.getSource()).getSender();
        PlayerServer user = (PlayerServer)((EntitySelector)ctx.getArgument("user", EntitySelector.class)).get((CommandSource)ctx.getSource()).get(0);
        String status = DB.toggleSocialSpy(user.uuid.toString()) ? "enabled" : "disabled";
        sender.sendMessage(TextFormatting.ORANGE + "SocialSpy for " + TextFormatting.RESET + user.getDisplayName() + TextFormatting.ORANGE + ": " + TextFormatting.RED + status);
        return 0;
    }

    private int exec3(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        Player sender = ((CommandSource)ctx.getSource()).getSender();
        PlayerServer user = (PlayerServer)((EntitySelector)ctx.getArgument("user", EntitySelector.class)).get((CommandSource)ctx.getSource()).get(0);
        String state = (String)ctx.getArgument("state", String.class);
        String status = "";
        if (Objects.equals(state, "on")) {
            DB.enableSocialSpy(user.uuid.toString());
            status = "enabled";
        }
        if (Objects.equals(state, "off")) {
            DB.disableSocialSpy(user.uuid.toString());
            status = "disabled";
        }
        sender.sendMessage(TextFormatting.ORANGE + "SocialSpy for " + TextFormatting.RESET + user.getDisplayName() + TextFormatting.ORANGE + ": " + TextFormatting.RED + status);
        return 0;
    }
}

