/*
 * Decompiled with CFR 0.152.
 */
package net.nebulabc.essentials;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Statement;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.minecraft.core.net.command.CommandManager;
import net.nebulabc.essentials.command.Broadcast;
import net.nebulabc.essentials.command.BroadcastWorld;
import net.nebulabc.essentials.command.GamemodeAdventure;
import net.nebulabc.essentials.command.GamemodeCreative;
import net.nebulabc.essentials.command.GamemodeSpectator;
import net.nebulabc.essentials.command.GamemodeSurvival;
import net.nebulabc.essentials.command.Kickall;
import net.nebulabc.essentials.command.Socialspy;
import net.nebulabc.essentials.command.Suicide;
import net.nebulabc.essentials.config.category.Global;
import net.nebulabc.essentials.util.DB;
import net.nebulabc.essentials.util.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import turniplabs.halplibe.util.GameStartEntrypoint;
import turniplabs.halplibe.util.RecipeEntrypoint;

public class Essentials
implements ModInitializer,
RecipeEntrypoint,
GameStartEntrypoint {
    public static final String MOD_ID = "essentials";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"essentials");

    public void onInitialize() {
        LOGGER.info("essentials initialized.");
    }

    public void onRecipesReady() {
    }

    public void initNamespaces() {
    }

    public void beforeGameStart() {
        this.config();
        this.db();
        this.registerCommands();
    }

    public void afterGameStart() {
    }

    public void db() {
        try {
            if (!Files.primaryDB.exists()) {
                Files.primaryDB.createNewFile();
                Statement stmt = DB.conn.createStatement();
                InputStream in = Essentials.class.getClassLoader().getResourceAsStream("primary.sql");
                if (in == null) {
                    throw new RuntimeException("Could not find primary.sql in resources.");
                }
                String sql = new BufferedReader(new InputStreamReader(in)).lines().collect(Collectors.joining("\n"));
                for (String statement : sql.split(";")) {
                    String trimmed = statement.trim();
                    if (trimmed.isEmpty()) continue;
                    stmt.execute(trimmed);
                }
                LOGGER.info("Database schema loaded successfully.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void config() {
        if (!Files.configFolder.exists()) {
            Files.configFolder.mkdir();
        }
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((String)"essentials/config.toml").defaultResource("/config/defaultConfig.toml").autosave().sync().build();
        config.load();
        Global.kickallOps = (Boolean)config.get("global.kickall-ops");
        Global.allowWorldInBroadcastworld = (Boolean)config.get("global.allow-world-in-broadcastworld");
        Global.socialspyMessages = (Boolean)config.get("global.socialspy-messages");
        Global.socialspyUsesDisplaynames = (Boolean)config.get("global.socialspy-uses-displaynames");
        config.close();
    }

    public void registerCommands() {
        CommandManager.registerCommand((CommandManager.CommandRegistry)new Broadcast());
        CommandManager.registerCommand((CommandManager.CommandRegistry)new Suicide());
        CommandManager.registerCommand((CommandManager.CommandRegistry)new Kickall());
        CommandManager.registerCommand((CommandManager.CommandRegistry)new Socialspy());
        CommandManager.registerCommand((CommandManager.CommandRegistry)new GamemodeCreative());
        CommandManager.registerCommand((CommandManager.CommandRegistry)new GamemodeSurvival());
        CommandManager.registerCommand((CommandManager.CommandRegistry)new GamemodeAdventure());
        CommandManager.registerCommand((CommandManager.CommandRegistry)new GamemodeSpectator());
        CommandManager.registerCommand((CommandManager.CommandRegistry)new BroadcastWorld());
    }
}

